<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Sqlserver\V20180328\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeSlowlogs返回参数结构体
 *
 * @method integer getTotalCount() 获取查询总数
 * @method void setTotalCount(integer $TotalCount) 设置查询总数
 * @method array getSlowlogs() 获取慢查询日志信息列表
 * @method void setSlowlogs(array $Slowlogs) 设置慢查询日志信息列表
 * @method array getSlowLogs() 获取慢查询日志信息列表
 * @method void setSlowLogs(array $SlowLogs) 设置慢查询日志信息列表
 * @method string getRequestId() 获取唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 * @method void setRequestId(string $RequestId) 设置唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 */
class DescribeSlowlogsResponse extends AbstractModel
{
    /**
     * @var integer 查询总数
     */
    public $TotalCount;

    /**
     * @var array 慢查询日志信息列表
     * @deprecated
     */
    public $Slowlogs;

    /**
     * @var array 慢查询日志信息列表
     */
    public $SlowLogs;

    /**
     * @var string 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public $RequestId;

    /**
     * @param integer $TotalCount 查询总数
     * @param array $Slowlogs 慢查询日志信息列表
     * @param array $SlowLogs 慢查询日志信息列表
     * @param string $RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("TotalCount",$param) and $param["TotalCount"] !== null) {
            $this->TotalCount = $param["TotalCount"];
        }

        if (array_key_exists("Slowlogs",$param) and $param["Slowlogs"] !== null) {
            $this->Slowlogs = [];
            foreach ($param["Slowlogs"] as $key => $value){
                $obj = new SlowlogInfo();
                $obj->deserialize($value);
                array_push($this->Slowlogs, $obj);
            }
        }

        if (array_key_exists("SlowLogs",$param) and $param["SlowLogs"] !== null) {
            $this->SlowLogs = [];
            foreach ($param["SlowLogs"] as $key => $value){
                $obj = new SlowLog();
                $obj->deserialize($value);
                array_push($this->SlowLogs, $obj);
            }
        }

        if (array_key_exists("RequestId",$param) and $param["RequestId"] !== null) {
            $this->RequestId = $param["RequestId"];
        }
    }
}
