<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Tat\V20201028\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeRegisterInstances请求参数结构体
 *
 * @method array getInstanceIds() 获取实例id。
 * @method void setInstanceIds(array $InstanceIds) 设置实例id。
 * @method array getFilters() 获取过滤器列表。

- instance-name

按照【实例名称】进行过滤。
类型：String
必选：否

- instance-id

按照【实例ID】进行过滤。
类型：String
必选：否

- register-code-id

按照【注册码ID】进行过滤。
类型：String
必选：否

- sys-name

按照【操作系统类型】进行过滤，取值：Linux | Windows。
类型：String
必选：否


 * @method void setFilters(array $Filters) 设置过滤器列表。

- instance-name

按照【实例名称】进行过滤。
类型：String
必选：否

- instance-id

按照【实例ID】进行过滤。
类型：String
必选：否

- register-code-id

按照【注册码ID】进行过滤。
类型：String
必选：否

- sys-name

按照【操作系统类型】进行过滤，取值：Linux | Windows。
类型：String
必选：否


 * @method integer getOffset() 获取偏移量，默认为 0。
 * @method void setOffset(integer $Offset) 设置偏移量，默认为 0。
 * @method integer getLimit() 获取返回数量，默认为 20，最大值为 100。
 * @method void setLimit(integer $Limit) 设置返回数量，默认为 20，最大值为 100。
 */
class DescribeRegisterInstancesRequest extends AbstractModel
{
    /**
     * @var array 实例id。
     */
    public $InstanceIds;

    /**
     * @var array 过滤器列表。

- instance-name

按照【实例名称】进行过滤。
类型：String
必选：否

- instance-id

按照【实例ID】进行过滤。
类型：String
必选：否

- register-code-id

按照【注册码ID】进行过滤。
类型：String
必选：否

- sys-name

按照【操作系统类型】进行过滤，取值：Linux | Windows。
类型：String
必选：否


     */
    public $Filters;

    /**
     * @var integer 偏移量，默认为 0。
     */
    public $Offset;

    /**
     * @var integer 返回数量，默认为 20，最大值为 100。
     */
    public $Limit;

    /**
     * @param array $InstanceIds 实例id。
     * @param array $Filters 过滤器列表。

- instance-name

按照【实例名称】进行过滤。
类型：String
必选：否

- instance-id

按照【实例ID】进行过滤。
类型：String
必选：否

- register-code-id

按照【注册码ID】进行过滤。
类型：String
必选：否

- sys-name

按照【操作系统类型】进行过滤，取值：Linux | Windows。
类型：String
必选：否


     * @param integer $Offset 偏移量，默认为 0。
     * @param integer $Limit 返回数量，默认为 20，最大值为 100。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("InstanceIds",$param) and $param["InstanceIds"] !== null) {
            $this->InstanceIds = $param["InstanceIds"];
        }

        if (array_key_exists("Filters",$param) and $param["Filters"] !== null) {
            $this->Filters = [];
            foreach ($param["Filters"] as $key => $value){
                $obj = new Filter();
                $obj->deserialize($value);
                array_push($this->Filters, $obj);
            }
        }

        if (array_key_exists("Offset",$param) and $param["Offset"] !== null) {
            $this->Offset = $param["Offset"];
        }

        if (array_key_exists("Limit",$param) and $param["Limit"] !== null) {
            $this->Limit = $param["Limit"];
        }
    }
}
