<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Tcss\V20201101\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 运行时安全事件趋势信息
 *
 * @method array getEventSet() 获取趋势列表
 * @method void setEventSet(array $EventSet) 设置趋势列表
 * @method string getEventType() 获取事件类型：
ET_ESCAPE : 容器逃逸
ET_REVERSE_SHELL: 反弹shell
ET_RISK_SYSCALL:高危系统调用
ET_ABNORMAL_PROCESS: 异常进程
ET_ACCESS_CONTROL 文件篡改
ET_VIRUS 木马事件
ET_MALICIOUS_CONNECTION 恶意外连事件
 * @method void setEventType(string $EventType) 设置事件类型：
ET_ESCAPE : 容器逃逸
ET_REVERSE_SHELL: 反弹shell
ET_RISK_SYSCALL:高危系统调用
ET_ABNORMAL_PROCESS: 异常进程
ET_ACCESS_CONTROL 文件篡改
ET_VIRUS 木马事件
ET_MALICIOUS_CONNECTION 恶意外连事件
 */
class SecTendencyEventInfo extends AbstractModel
{
    /**
     * @var array 趋势列表
     */
    public $EventSet;

    /**
     * @var string 事件类型：
ET_ESCAPE : 容器逃逸
ET_REVERSE_SHELL: 反弹shell
ET_RISK_SYSCALL:高危系统调用
ET_ABNORMAL_PROCESS: 异常进程
ET_ACCESS_CONTROL 文件篡改
ET_VIRUS 木马事件
ET_MALICIOUS_CONNECTION 恶意外连事件
     */
    public $EventType;

    /**
     * @param array $EventSet 趋势列表
     * @param string $EventType 事件类型：
ET_ESCAPE : 容器逃逸
ET_REVERSE_SHELL: 反弹shell
ET_RISK_SYSCALL:高危系统调用
ET_ABNORMAL_PROCESS: 异常进程
ET_ACCESS_CONTROL 文件篡改
ET_VIRUS 木马事件
ET_MALICIOUS_CONNECTION 恶意外连事件
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("EventSet",$param) and $param["EventSet"] !== null) {
            $this->EventSet = [];
            foreach ($param["EventSet"] as $key => $value){
                $obj = new RunTimeTendencyInfo();
                $obj->deserialize($value);
                array_push($this->EventSet, $obj);
            }
        }

        if (array_key_exists("EventType",$param) and $param["EventType"] !== null) {
            $this->EventType = $param["EventType"];
        }
    }
}
