<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Tke\V20180525\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeClusterReleases返回参数结构体
 *
 * @method integer getLimit() 获取数量限制
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setLimit(integer $Limit) 设置数量限制
注意：此字段可能返回 null，表示取不到有效值。
 * @method integer getOffset() 获取偏移量
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setOffset(integer $Offset) 设置偏移量
注意：此字段可能返回 null，表示取不到有效值。
 * @method array getReleaseSet() 获取已安装应用列表
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setReleaseSet(array $ReleaseSet) 设置已安装应用列表
注意：此字段可能返回 null，表示取不到有效值。
 * @method integer getTotal() 获取已安装应用总数量
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setTotal(integer $Total) 设置已安装应用总数量
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getRequestId() 获取唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 * @method void setRequestId(string $RequestId) 设置唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
 */
class DescribeClusterReleasesResponse extends AbstractModel
{
    /**
     * @var integer 数量限制
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Limit;

    /**
     * @var integer 偏移量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Offset;

    /**
     * @var array 已安装应用列表
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $ReleaseSet;

    /**
     * @var integer 已安装应用总数量
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Total;

    /**
     * @var string 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public $RequestId;

    /**
     * @param integer $Limit 数量限制
注意：此字段可能返回 null，表示取不到有效值。
     * @param integer $Offset 偏移量
注意：此字段可能返回 null，表示取不到有效值。
     * @param array $ReleaseSet 已安装应用列表
注意：此字段可能返回 null，表示取不到有效值。
     * @param integer $Total 已安装应用总数量
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Limit",$param) and $param["Limit"] !== null) {
            $this->Limit = $param["Limit"];
        }

        if (array_key_exists("Offset",$param) and $param["Offset"] !== null) {
            $this->Offset = $param["Offset"];
        }

        if (array_key_exists("ReleaseSet",$param) and $param["ReleaseSet"] !== null) {
            $this->ReleaseSet = [];
            foreach ($param["ReleaseSet"] as $key => $value){
                $obj = new Release();
                $obj->deserialize($value);
                array_push($this->ReleaseSet, $obj);
            }
        }

        if (array_key_exists("Total",$param) and $param["Total"] !== null) {
            $this->Total = $param["Total"];
        }

        if (array_key_exists("RequestId",$param) and $param["RequestId"] !== null) {
            $this->RequestId = $param["RequestId"];
        }
    }
}
