<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Tse\V20201207\Models;
use TencentCloud\Common\AbstractModel;

/**
 * 服务的 WAF 状态
 *
 * @method string getName() 获取 服务的名字
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setName(string $Name) 设置 服务的名字
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getId() 获取服务的 ID
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setId(string $Id) 设置服务的 ID
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getType() 获取服务的类型
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setType(string $Type) 设置服务的类型
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getStatus() 获取 服务是否开启 WAF 防护
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setStatus(string $Status) 设置 服务是否开启 WAF 防护
注意：此字段可能返回 null，表示取不到有效值。
 */
class ServiceWafStatus extends AbstractModel
{
    /**
     * @var string  服务的名字
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Name;

    /**
     * @var string 服务的 ID
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Id;

    /**
     * @var string 服务的类型
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Type;

    /**
     * @var string  服务是否开启 WAF 防护
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $Status;

    /**
     * @param string $Name  服务的名字
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $Id 服务的 ID
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $Type 服务的类型
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $Status  服务是否开启 WAF 防护
注意：此字段可能返回 null，表示取不到有效值。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("Name",$param) and $param["Name"] !== null) {
            $this->Name = $param["Name"];
        }

        if (array_key_exists("Id",$param) and $param["Id"] !== null) {
            $this->Id = $param["Id"];
        }

        if (array_key_exists("Type",$param) and $param["Type"] !== null) {
            $this->Type = $param["Type"];
        }

        if (array_key_exists("Status",$param) and $param["Status"] !== null) {
            $this->Status = $param["Status"];
        }
    }
}
