<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Tsf\V20180326\Models;
use TencentCloud\Common\AbstractModel;

/**
 * DescribeMicroservices请求参数结构体
 *
 * @method string getNamespaceId() 获取命名空间ID
 * @method void setNamespaceId(string $NamespaceId) 设置命名空间ID
 * @method string getSearchWord() 获取搜索字段
 * @method void setSearchWord(string $SearchWord) 设置搜索字段
 * @method string getOrderBy() 获取排序字段
 * @method void setOrderBy(string $OrderBy) 设置排序字段
 * @method integer getOrderType() 获取排序类型
 * @method void setOrderType(integer $OrderType) 设置排序类型
 * @method integer getOffset() 获取偏移量
 * @method void setOffset(integer $Offset) 设置偏移量
 * @method integer getLimit() 获取分页个数
 * @method void setLimit(integer $Limit) 设置分页个数
 * @method array getStatus() 获取状态过滤，online、offline、single_online
 * @method void setStatus(array $Status) 设置状态过滤，online、offline、single_online
 * @method array getMicroserviceIdList() 获取IdList
 * @method void setMicroserviceIdList(array $MicroserviceIdList) 设置IdList
 * @method array getMicroserviceNameList() 获取搜索的服务名列表
 * @method void setMicroserviceNameList(array $MicroserviceNameList) 设置搜索的服务名列表
 */
class DescribeMicroservicesRequest extends AbstractModel
{
    /**
     * @var string 命名空间ID
     */
    public $NamespaceId;

    /**
     * @var string 搜索字段
     */
    public $SearchWord;

    /**
     * @var string 排序字段
     */
    public $OrderBy;

    /**
     * @var integer 排序类型
     */
    public $OrderType;

    /**
     * @var integer 偏移量
     */
    public $Offset;

    /**
     * @var integer 分页个数
     */
    public $Limit;

    /**
     * @var array 状态过滤，online、offline、single_online
     */
    public $Status;

    /**
     * @var array IdList
     */
    public $MicroserviceIdList;

    /**
     * @var array 搜索的服务名列表
     */
    public $MicroserviceNameList;

    /**
     * @param string $NamespaceId 命名空间ID
     * @param string $SearchWord 搜索字段
     * @param string $OrderBy 排序字段
     * @param integer $OrderType 排序类型
     * @param integer $Offset 偏移量
     * @param integer $Limit 分页个数
     * @param array $Status 状态过滤，online、offline、single_online
     * @param array $MicroserviceIdList IdList
     * @param array $MicroserviceNameList 搜索的服务名列表
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("NamespaceId",$param) and $param["NamespaceId"] !== null) {
            $this->NamespaceId = $param["NamespaceId"];
        }

        if (array_key_exists("SearchWord",$param) and $param["SearchWord"] !== null) {
            $this->SearchWord = $param["SearchWord"];
        }

        if (array_key_exists("OrderBy",$param) and $param["OrderBy"] !== null) {
            $this->OrderBy = $param["OrderBy"];
        }

        if (array_key_exists("OrderType",$param) and $param["OrderType"] !== null) {
            $this->OrderType = $param["OrderType"];
        }

        if (array_key_exists("Offset",$param) and $param["Offset"] !== null) {
            $this->Offset = $param["Offset"];
        }

        if (array_key_exists("Limit",$param) and $param["Limit"] !== null) {
            $this->Limit = $param["Limit"];
        }

        if (array_key_exists("Status",$param) and $param["Status"] !== null) {
            $this->Status = $param["Status"];
        }

        if (array_key_exists("MicroserviceIdList",$param) and $param["MicroserviceIdList"] !== null) {
            $this->MicroserviceIdList = $param["MicroserviceIdList"];
        }

        if (array_key_exists("MicroserviceNameList",$param) and $param["MicroserviceNameList"] !== null) {
            $this->MicroserviceNameList = $param["MicroserviceNameList"];
        }
    }
}
