<?php
/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
namespace TencentCloud\Vpc\V20170312\Models;
use TencentCloud\Common\AbstractModel;

/**
 * VPN通道对象。
 *
 * @method string getVpnConnectionId() 获取通道实例ID。
 * @method void setVpnConnectionId(string $VpnConnectionId) 设置通道实例ID。
 * @method string getVpnConnectionName() 获取通道名称。
 * @method void setVpnConnectionName(string $VpnConnectionName) 设置通道名称。
 * @method string getVpcId() 获取VPC实例ID。
 * @method void setVpcId(string $VpcId) 设置VPC实例ID。
 * @method string getVpnGatewayId() 获取VPN网关实例ID。
 * @method void setVpnGatewayId(string $VpnGatewayId) 设置VPN网关实例ID。
 * @method string getCustomerGatewayId() 获取对端网关实例ID。
 * @method void setCustomerGatewayId(string $CustomerGatewayId) 设置对端网关实例ID。
 * @method string getPreShareKey() 获取预共享密钥。
 * @method void setPreShareKey(string $PreShareKey) 设置预共享密钥。
 * @method string getVpnProto() 获取通道传输协议。
 * @method void setVpnProto(string $VpnProto) 设置通道传输协议。
 * @method string getEncryptProto() 获取通道加密协议。
 * @method void setEncryptProto(string $EncryptProto) 设置通道加密协议。
 * @method string getRouteType() 获取路由类型。
 * @method void setRouteType(string $RouteType) 设置路由类型。
 * @method string getCreatedTime() 获取创建时间。
 * @method void setCreatedTime(string $CreatedTime) 设置创建时间。
 * @method string getState() 获取通道的生产状态，PENDING：生产中，AVAILABLE：运行中，DELETING：删除中。
 * @method void setState(string $State) 设置通道的生产状态，PENDING：生产中，AVAILABLE：运行中，DELETING：删除中。
 * @method string getNetStatus() 获取通道连接状态，AVAILABLE：已连接。
 * @method void setNetStatus(string $NetStatus) 设置通道连接状态，AVAILABLE：已连接。
 * @method array getSecurityPolicyDatabaseSet() 获取SPD。
 * @method void setSecurityPolicyDatabaseSet(array $SecurityPolicyDatabaseSet) 设置SPD。
 * @method IKEOptionsSpecification getIKEOptionsSpecification() 获取IKE选项。
 * @method void setIKEOptionsSpecification(IKEOptionsSpecification $IKEOptionsSpecification) 设置IKE选项。
 * @method IPSECOptionsSpecification getIPSECOptionsSpecification() 获取IPSEC选择。
 * @method void setIPSECOptionsSpecification(IPSECOptionsSpecification $IPSECOptionsSpecification) 设置IPSEC选择。
 * @method boolean getEnableHealthCheck() 获取是否支持健康状态探测
 * @method void setEnableHealthCheck(boolean $EnableHealthCheck) 设置是否支持健康状态探测
 * @method string getHealthCheckLocalIp() 获取本端探测ip
 * @method void setHealthCheckLocalIp(string $HealthCheckLocalIp) 设置本端探测ip
 * @method string getHealthCheckRemoteIp() 获取对端探测ip
 * @method void setHealthCheckRemoteIp(string $HealthCheckRemoteIp) 设置对端探测ip
 * @method string getHealthCheckStatus() 获取通道健康检查状态，AVAILABLE：正常，UNAVAILABLE：不正常。 未配置健康检查不返回该对象
 * @method void setHealthCheckStatus(string $HealthCheckStatus) 设置通道健康检查状态，AVAILABLE：正常，UNAVAILABLE：不正常。 未配置健康检查不返回该对象
 * @method integer getDpdEnable() 获取DPD探测开关。默认为0，表示关闭DPD探测。可选值：0（关闭），1（开启）
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setDpdEnable(integer $DpdEnable) 设置DPD探测开关。默认为0，表示关闭DPD探测。可选值：0（关闭），1（开启）
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getDpdTimeout() 获取DPD超时时间。即探测确认对端不存在需要的时间。
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setDpdTimeout(string $DpdTimeout) 设置DPD超时时间。即探测确认对端不存在需要的时间。
注意：此字段可能返回 null，表示取不到有效值。
 * @method string getDpdAction() 获取DPD超时后的动作。默认为clear。dpdEnable为1（开启）时有效。可取值为clear（断开）和restart（重试）
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setDpdAction(string $DpdAction) 设置DPD超时后的动作。默认为clear。dpdEnable为1（开启）时有效。可取值为clear（断开）和restart（重试）
注意：此字段可能返回 null，表示取不到有效值。
 * @method array getTagSet() 获取标签键值对数组
 * @method void setTagSet(array $TagSet) 设置标签键值对数组
 * @method string getNegotiationType() 获取协商类型
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setNegotiationType(string $NegotiationType) 设置协商类型
注意：此字段可能返回 null，表示取不到有效值。
 * @method BgpConfigAndAsn getBgpConfig() 获取Bgp配置信息
注意：此字段可能返回 null，表示取不到有效值。
 * @method void setBgpConfig(BgpConfigAndAsn $BgpConfig) 设置Bgp配置信息
注意：此字段可能返回 null，表示取不到有效值。
 */
class VpnConnection extends AbstractModel
{
    /**
     * @var string 通道实例ID。
     */
    public $VpnConnectionId;

    /**
     * @var string 通道名称。
     */
    public $VpnConnectionName;

    /**
     * @var string VPC实例ID。
     */
    public $VpcId;

    /**
     * @var string VPN网关实例ID。
     */
    public $VpnGatewayId;

    /**
     * @var string 对端网关实例ID。
     */
    public $CustomerGatewayId;

    /**
     * @var string 预共享密钥。
     */
    public $PreShareKey;

    /**
     * @var string 通道传输协议。
     */
    public $VpnProto;

    /**
     * @var string 通道加密协议。
     */
    public $EncryptProto;

    /**
     * @var string 路由类型。
     */
    public $RouteType;

    /**
     * @var string 创建时间。
     */
    public $CreatedTime;

    /**
     * @var string 通道的生产状态，PENDING：生产中，AVAILABLE：运行中，DELETING：删除中。
     */
    public $State;

    /**
     * @var string 通道连接状态，AVAILABLE：已连接。
     */
    public $NetStatus;

    /**
     * @var array SPD。
     */
    public $SecurityPolicyDatabaseSet;

    /**
     * @var IKEOptionsSpecification IKE选项。
     */
    public $IKEOptionsSpecification;

    /**
     * @var IPSECOptionsSpecification IPSEC选择。
     */
    public $IPSECOptionsSpecification;

    /**
     * @var boolean 是否支持健康状态探测
     */
    public $EnableHealthCheck;

    /**
     * @var string 本端探测ip
     */
    public $HealthCheckLocalIp;

    /**
     * @var string 对端探测ip
     */
    public $HealthCheckRemoteIp;

    /**
     * @var string 通道健康检查状态，AVAILABLE：正常，UNAVAILABLE：不正常。 未配置健康检查不返回该对象
     */
    public $HealthCheckStatus;

    /**
     * @var integer DPD探测开关。默认为0，表示关闭DPD探测。可选值：0（关闭），1（开启）
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $DpdEnable;

    /**
     * @var string DPD超时时间。即探测确认对端不存在需要的时间。
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $DpdTimeout;

    /**
     * @var string DPD超时后的动作。默认为clear。dpdEnable为1（开启）时有效。可取值为clear（断开）和restart（重试）
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $DpdAction;

    /**
     * @var array 标签键值对数组
     */
    public $TagSet;

    /**
     * @var string 协商类型
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $NegotiationType;

    /**
     * @var BgpConfigAndAsn Bgp配置信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    public $BgpConfig;

    /**
     * @param string $VpnConnectionId 通道实例ID。
     * @param string $VpnConnectionName 通道名称。
     * @param string $VpcId VPC实例ID。
     * @param string $VpnGatewayId VPN网关实例ID。
     * @param string $CustomerGatewayId 对端网关实例ID。
     * @param string $PreShareKey 预共享密钥。
     * @param string $VpnProto 通道传输协议。
     * @param string $EncryptProto 通道加密协议。
     * @param string $RouteType 路由类型。
     * @param string $CreatedTime 创建时间。
     * @param string $State 通道的生产状态，PENDING：生产中，AVAILABLE：运行中，DELETING：删除中。
     * @param string $NetStatus 通道连接状态，AVAILABLE：已连接。
     * @param array $SecurityPolicyDatabaseSet SPD。
     * @param IKEOptionsSpecification $IKEOptionsSpecification IKE选项。
     * @param IPSECOptionsSpecification $IPSECOptionsSpecification IPSEC选择。
     * @param boolean $EnableHealthCheck 是否支持健康状态探测
     * @param string $HealthCheckLocalIp 本端探测ip
     * @param string $HealthCheckRemoteIp 对端探测ip
     * @param string $HealthCheckStatus 通道健康检查状态，AVAILABLE：正常，UNAVAILABLE：不正常。 未配置健康检查不返回该对象
     * @param integer $DpdEnable DPD探测开关。默认为0，表示关闭DPD探测。可选值：0（关闭），1（开启）
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $DpdTimeout DPD超时时间。即探测确认对端不存在需要的时间。
注意：此字段可能返回 null，表示取不到有效值。
     * @param string $DpdAction DPD超时后的动作。默认为clear。dpdEnable为1（开启）时有效。可取值为clear（断开）和restart（重试）
注意：此字段可能返回 null，表示取不到有效值。
     * @param array $TagSet 标签键值对数组
     * @param string $NegotiationType 协商类型
注意：此字段可能返回 null，表示取不到有效值。
     * @param BgpConfigAndAsn $BgpConfig Bgp配置信息
注意：此字段可能返回 null，表示取不到有效值。
     */
    function __construct()
    {

    }

    /**
     * For internal only. DO NOT USE IT.
     */
    public function deserialize($param)
    {
        if ($param === null) {
            return;
        }
        if (array_key_exists("VpnConnectionId",$param) and $param["VpnConnectionId"] !== null) {
            $this->VpnConnectionId = $param["VpnConnectionId"];
        }

        if (array_key_exists("VpnConnectionName",$param) and $param["VpnConnectionName"] !== null) {
            $this->VpnConnectionName = $param["VpnConnectionName"];
        }

        if (array_key_exists("VpcId",$param) and $param["VpcId"] !== null) {
            $this->VpcId = $param["VpcId"];
        }

        if (array_key_exists("VpnGatewayId",$param) and $param["VpnGatewayId"] !== null) {
            $this->VpnGatewayId = $param["VpnGatewayId"];
        }

        if (array_key_exists("CustomerGatewayId",$param) and $param["CustomerGatewayId"] !== null) {
            $this->CustomerGatewayId = $param["CustomerGatewayId"];
        }

        if (array_key_exists("PreShareKey",$param) and $param["PreShareKey"] !== null) {
            $this->PreShareKey = $param["PreShareKey"];
        }

        if (array_key_exists("VpnProto",$param) and $param["VpnProto"] !== null) {
            $this->VpnProto = $param["VpnProto"];
        }

        if (array_key_exists("EncryptProto",$param) and $param["EncryptProto"] !== null) {
            $this->EncryptProto = $param["EncryptProto"];
        }

        if (array_key_exists("RouteType",$param) and $param["RouteType"] !== null) {
            $this->RouteType = $param["RouteType"];
        }

        if (array_key_exists("CreatedTime",$param) and $param["CreatedTime"] !== null) {
            $this->CreatedTime = $param["CreatedTime"];
        }

        if (array_key_exists("State",$param) and $param["State"] !== null) {
            $this->State = $param["State"];
        }

        if (array_key_exists("NetStatus",$param) and $param["NetStatus"] !== null) {
            $this->NetStatus = $param["NetStatus"];
        }

        if (array_key_exists("SecurityPolicyDatabaseSet",$param) and $param["SecurityPolicyDatabaseSet"] !== null) {
            $this->SecurityPolicyDatabaseSet = [];
            foreach ($param["SecurityPolicyDatabaseSet"] as $key => $value){
                $obj = new SecurityPolicyDatabase();
                $obj->deserialize($value);
                array_push($this->SecurityPolicyDatabaseSet, $obj);
            }
        }

        if (array_key_exists("IKEOptionsSpecification",$param) and $param["IKEOptionsSpecification"] !== null) {
            $this->IKEOptionsSpecification = new IKEOptionsSpecification();
            $this->IKEOptionsSpecification->deserialize($param["IKEOptionsSpecification"]);
        }

        if (array_key_exists("IPSECOptionsSpecification",$param) and $param["IPSECOptionsSpecification"] !== null) {
            $this->IPSECOptionsSpecification = new IPSECOptionsSpecification();
            $this->IPSECOptionsSpecification->deserialize($param["IPSECOptionsSpecification"]);
        }

        if (array_key_exists("EnableHealthCheck",$param) and $param["EnableHealthCheck"] !== null) {
            $this->EnableHealthCheck = $param["EnableHealthCheck"];
        }

        if (array_key_exists("HealthCheckLocalIp",$param) and $param["HealthCheckLocalIp"] !== null) {
            $this->HealthCheckLocalIp = $param["HealthCheckLocalIp"];
        }

        if (array_key_exists("HealthCheckRemoteIp",$param) and $param["HealthCheckRemoteIp"] !== null) {
            $this->HealthCheckRemoteIp = $param["HealthCheckRemoteIp"];
        }

        if (array_key_exists("HealthCheckStatus",$param) and $param["HealthCheckStatus"] !== null) {
            $this->HealthCheckStatus = $param["HealthCheckStatus"];
        }

        if (array_key_exists("DpdEnable",$param) and $param["DpdEnable"] !== null) {
            $this->DpdEnable = $param["DpdEnable"];
        }

        if (array_key_exists("DpdTimeout",$param) and $param["DpdTimeout"] !== null) {
            $this->DpdTimeout = $param["DpdTimeout"];
        }

        if (array_key_exists("DpdAction",$param) and $param["DpdAction"] !== null) {
            $this->DpdAction = $param["DpdAction"];
        }

        if (array_key_exists("TagSet",$param) and $param["TagSet"] !== null) {
            $this->TagSet = [];
            foreach ($param["TagSet"] as $key => $value){
                $obj = new Tag();
                $obj->deserialize($value);
                array_push($this->TagSet, $obj);
            }
        }

        if (array_key_exists("NegotiationType",$param) and $param["NegotiationType"] !== null) {
            $this->NegotiationType = $param["NegotiationType"];
        }

        if (array_key_exists("BgpConfig",$param) and $param["BgpConfig"] !== null) {
            $this->BgpConfig = new BgpConfigAndAsn();
            $this->BgpConfig->deserialize($param["BgpConfig"]);
        }
    }
}
